/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "LayerRemoveCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"
#include <sstream>

ExecutionResult LayerRemoveCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());

    ExecutionResult result = ExecutionFailed;

    Layer* layer = scene.getLayer(m_idToRemove);
    if (layer)
    {
        ilmObjectNotification objNotification = {ILM_LAYER,m_idToRemove,ILM_FALSE};
        executor->addNewObjectNotification(objNotification);

        if (scene.removeLayer(layer))
        {
            IRenderer* renderer = *((executor->getRendererList())->begin());

            renderer->forceCompositionWindowSystem();
            result = ExecutionSuccessRedraw;

        }
        else
        {
            result = ExecutionSuccess;
        }
    }

    return result;
}

const std::string LayerRemoveCommand::getString()
{
    std::stringstream description;
    description << "LayerRemoveCommand("
                << "idToRemove=" << m_idToRemove << "(0x" << std::hex << m_idToRemove << ")" << std::dec
                << ")";
    return description.str();
}
